
-- 298, 7-14

USE BD_Air_France;

IF OBJECT_ID ('dbo.T_aeroport_aer','U') IS NOT NULL
    DROP TABLE dbo.T_aeroport_aer;
GO

CREATE TABLE T_aeroport_aer
 (aer_IATA   VARCHAR(3),
  aer_OACI   VARCHAR(6)  NOT NULL,
  aer_nom    VARCHAR(50) NOT NULL,
  CONSTRAINT PK_aer      PRIMARY KEY(aer_IATA),
  CONSTRAINT UK_aer_OACI UNIQUE(aer_OACI));

BEGIN TRANSACTION 
INSERT INTO T_aeroport_aer
       VALUES ('TLS','LFBO','Toulouse Blagnac');
INSERT INTO T_aeroport_aer (aer_IATA, aer_OACI, aer_nom) 
       VALUES ('ORY','LFPO','Paris Orly');
INSERT INTO T_aeroport_aer (aer_nom, aer_OACI, aer_IATA) 
       VALUES ('Marseille Provence', 'LFML', 'MRS');
COMMIT TRANSACTION;

DECLARE @aer_OACI  VARCHAR(6);
DECLARE @aer_nom   VARCHAR(50);
DECLARE @aer_OACI2 VARCHAR(6) = 'LFBO';
DECLARE @aer_nom2  VARCHAR(50);
BEGIN
 SELECT @aer_nom=aer_nom, @aer_OACI=aer_OACI
        FROM T_aeroport_aer WHERE aer_IATA='MRS';	
 SELECT @aer_nom2=aer_nom
        FROM T_aeroport_aer WHERE aer_OACI=@aer_OACI2;		
END;
PRINT 'Code OACI et nom aroport : '+@aer_OACI+' '+@aer_nom;
PRINT 'Nom aroport de '+@aer_OACI2+' : '+@aer_nom2;

-- fonctions

DECLARE @aer_OACI VARCHAR(6) = 'lfpo';
DECLARE @aer_nom  VARCHAR(50);
BEGIN	
 SELECT @aer_nom=LOWER(aer_nom)
 FROM   T_aeroport_aer WHERE aer_OACI=UPPER(@aer_OACI);		
END;
PRINT 'Nombre de lignes retournes : '+CAST(@@rowcount AS CHAR(3));
PRINT 'Nom aroport : '+@aer_nom;

-- 299, 7-75

DECLARE @aer_OACI VARCHAR(6);
DECLARE @aer_nom  VARCHAR(50);
DECLARE @aer_IATA VARCHAR(3) = 'LYO';  --> LYS

BEGIN TRANSACTION 
-- avec des constantes
  INSERT INTO T_aeroport_aer
         (aer_IATA, aer_OACI, aer_nom) 
         VALUES ('NCE','LFMN','Nice cote d''Azur');
-- avec des variables
  SET @aer_OACI = 'LFLL';
  SET @aer_nom  = 'Lyon Satolas'; --> Saint Exupry
  INSERT INTO T_aeroport_aer
         (aer_IATA, aer_nom, aer_OACI) 
         VALUES (@aer_IATA,@aer_nom,@aer_OACI );
COMMIT TRANSACTION;

SELECT * FROM T_aeroport_aer;

-- 300, 7-16

DECLARE @aer_nom    VARCHAR(50) = 'Lyon Saint Exupry'
       ,@aer_IATA   VARCHAR(3)
       ,@aer_oldnom VARCHAR(50);
BEGIN
  SET    @aer_IATA = 'LYS';
  UPDATE T_aeroport_aer 
   SET   @aer_oldnom = aer_nom,
         aer_nom     = @aer_nom,
         aer_IATA   = @aer_IATA,
  WHERE  aer_IATA = 'LYO';
END;
PRINT 'Nombre de lignes modifies : '+CAST(@@rowcount AS CHAR(3));
PRINT 'Ancien nom : '+@aer_oldnom;

SELECT * FROM T_aeroport_aer;

-- 300, 7-17

DECLARE @aer_IATA1  VARCHAR(3);
DECLARE @aer_IATA2 VARCHAR(3);
BEGIN
  SET    @aer_IATA1 = 'LYS';
  SET    @aer_IATA2 = 'NCE';
  DELETE FROM T_aeroport_aer 
    WHERE     aer_IATA = @aer_IATA1 
    OR        aer_IATA = @aer_IATA2;
END;
PRINT 'Nombre de lignes supprimes : '+CAST(@@rowcount AS CHAR(3));


IF OBJECT_ID ('dbo.T_aeroport_aer','U') IS NOT NULL
    DROP TABLE dbo.T_aeroport_aer;
GO
